#include "ft.h"

#include <stdlib.h>

/* slower does not have transparency, must have svgalib, 
and wastes memory, but works in non linear modes */
/*
#define USE_DRAWSCANSEGMENT 
*/

unsigned char *graphbase;

#ifdef USE_DRAWSCANSEGMENT

#include <vga.h>

static unsigned char linebuf[8192];

static void drawscansegment1(unsigned char *pixmap, int x, int y, 
                            int width, int fg, int bg, int transparent)
{
    unsigned char *p;
    int i, j, byte;
    
    p=linebuf;
    for(i=0;i<(width>>3);i++) {
        byte=*(pixmap+i);
        for(j=0;j<8;j++) {
            if(byte&0x80) *p=fg; else *p=bg;
            p++;
            byte<<=1;
        }
    }
    byte=*(pixmap+i);
    for(j=0;j<(width&7);j++) {
        if(byte&0x80) *p=fg; else *p=bg;
        p++;
        byte<<=1;
    }
    vga_drawscansegment(linebuf,x,y,width);
}

static void drawscansegment2(unsigned char *pixmap, int x, int y, 
                            int width, int fg, int bg, int transparent)
{
    unsigned short *p;
    int i, j, byte;
    
    p=(unsigned short *)linebuf;
    for(i=0;i<(width>>3);i++) {
        byte=*(pixmap+i);
        for(j=0;j<8;j++) {
            if(byte&0x80) *p=fg; else *p=bg;
            p++;
            byte<<=1;
        }
    }
    byte=*(pixmap+i);
    for(j=0;j<(width&7);j++) {
        if(byte&0x80) *p=fg; else *p=bg;
        p++;
        byte<<=1;
    }    
    vga_drawscansegment(linebuf,x,y,width*2);
}

static void drawscansegment4(unsigned char *pixmap, int x, int y,
                            int width, int fg, int bg, int transparent)
{
    unsigned int *p;
    int i, j, byte;
    
    p=(unsigned int *)linebuf;
    for(i=0;i<(width>>3);i++) {
        byte=*(pixmap+i);
        for(j=0;j<8;j++) {
            if(byte&0x80) *p=fg; else *p=bg;
            p++;
            byte<<=1;
        }
    }
    byte=*(pixmap+i);
    for(j=0;j<(width&7);j++) {
        if(byte&0x80) *p=fg; else *p=bg;
        p++;
        byte<<=1;
    }    
    vga_drawscansegment(linebuf,x,y,width*4);
}

static void drawscansegment3(unsigned char *pixmap, int x, int y,
                            int width, int fg, int bg, int transparent)
{
    unsigned char *p;
    int i, j, byte;
    
    p=linebuf;
    for(i=0;i<(width>>3);i++) {
        byte=*(pixmap+i);
        for(j=0;j<8;j++) {
            if(byte&0x80) {
                *p=fg;
                p[1]=fg>>8;
                p[2]=fg>>16;
            } else {
                *p=bg;
                p[1]=bg>>8;
                p[2]=bg>>16;
            }
            p+=3;
            byte<<=1;
        }
    }
    byte=*(pixmap+i);
    for(j=0;j<(width&7);j++) {
        if(byte&0x80) {
            *p=fg;
            p[1]=fg>>8;
            p[2]=fg>>16;
        } else {
            *p=bg;
            p[1]=bg>>8;
            p[2]=bg>>16;
        }
        
        p+=3;
        byte<<=1;
    }    
    vga_drawscansegment(linebuf,x,y,width*3);
}

int drawchar(font_element *font, int chr, int x, int y, int fg, int bg, int transparent)
{
    int i;

    y-=font[chr].metrics.horiBearingY>>6;
    x+=font[chr].metrics.horiBearingX>>6;
    for(i=0;i<font[chr].bitmap.rows;i++) {
        switch(screen_bpp) {
            case 1:
                drawscansegment1(font[chr].bitmap.buffer+i*font[chr].bitmap.pitch, x, y+i, 
                               font[chr].bitmap.width, fg, bg, transparent);
            break;
            case 2:
                drawscansegment2(font[chr].bitmap.buffer+i*font[chr].bitmap.pitch, x, y+i, 
                               font[chr].bitmap.width, fg, bg, transparent);
            break;
            case 3:
                drawscansegment3(font[chr].bitmap.buffer+i*font[chr].bitmap.pitch, x, y+i, 
                               font[chr].bitmap.width, fg, bg, transparent);
            break;
            case 4:
                drawscansegment4(font[chr].bitmap.buffer+i*font[chr].bitmap.pitch, x, y+i, 
                               font[chr].bitmap.width, fg, bg, transparent);
            break;
        }
    }
    return (font[chr].metrics.horiAdvance+0x3f)>>6;
}

#else

static void drawscansegment0linear(unsigned char *pixmap, int x, int y, 
                            int width, int fg, int bg, int transparent)
{
    unsigned char *p;
    int i;
    int scroll,lscroll;
    
    scroll=x&7;
    lscroll=8-scroll;
    
    p=graphbase+y*screen_pitch+(x>>3);
    
    *p|=*pixmap>>scroll;
    p++;
    
    for(i=1;i<((width-lscroll)>>3);i++) {
        *p=(*(pixmap+i-1)<<lscroll)|(*(pixmap+i)>>scroll);
        p++;
    }
    *p|=*(pixmap+i-1)<<lscroll;
}

static void drawscansegment1linear(unsigned char *pixmap, int x, int y, 
                            int width, int fg, int bg, int transparent)
{
    unsigned char *p;
    int i, j, byte;
    
    p=graphbase+y*screen_pitch+x;
    for(i=0;i<(width>>3);i++) {
        byte=*(pixmap+i);
        for(j=0;j<8;j++) {
            if(byte&0x80) *p=fg; else if(!transparent) *p=bg;
            p++;
            byte<<=1;
        }
    }
    byte=*(pixmap+i);
    for(j=0;j<(width&7);j++) {
        if(byte&0x80) *p=fg; else if(!transparent) *p=bg;
        p++;
        byte<<=1;
    }    
}

static void drawscansegment2linear(unsigned char *pixmap, int x, int y, 
                            int width, int fg, int bg, int transparent)
{
    unsigned short *p;
    int i, j, byte;
    
    p=(unsigned short *)(graphbase+y*screen_pitch+x*2);
    for(i=0;i<(width>>3);i++) {
        byte=*(pixmap+i);
        for(j=0;j<8;j++) {
            if(byte&0x80) *p=fg; else if(!transparent) *p=bg;
            p++;
            byte<<=1;
        }
    }
    byte=*(pixmap+i);
    for(j=0;j<(width&7);j++) {
        if(byte&0x80) *p=fg; else if(!transparent) *p=bg;
        p++;
        byte<<=1;
    }    
}

static void drawscansegment4linear(unsigned char *pixmap, int x, int y,
                            int width, int fg, int bg, int transparent)
{
    unsigned int *p;
    int i, j, byte;
    
    p=(unsigned int *)(graphbase+y*screen_pitch+x*4);
    for(i=0;i<(width>>3);i++) {
        byte=*(pixmap+i);
        for(j=0;j<8;j++) {
            if(byte&0x80) *p=fg; else if(!transparent) *p=bg;
            p++;
            byte<<=1;
        }
    }
    byte=*(pixmap+i);
    for(j=0;j<(width&7);j++) {
        if(byte&0x80) *p=fg; else if(!transparent) *p=bg;
        p++;
        byte<<=1;
    }    
}

static void drawscansegment3linear(unsigned char *pixmap, int x, int y,
                            int width, int fg, int bg, int transparent)
{
    unsigned char *p;
    int i, j, byte;
    
    p=graphbase+y*screen_pitch+x*3;
    for(i=0;i<(width>>3);i++) {
        byte=*(pixmap+i);
        for(j=0;j<8;j++) {
            if(byte&0x80) {
                *p=fg;
                p[1]=fg>>8;
                p[2]=fg>>16;
            } else if(!transparent) {
                *p=bg;
                p[1]=bg>>8;
                p[2]=bg>>16;
            }
            p+=3;
            byte<<=1;
        }
    }
    byte=*(pixmap+i);
    for(j=0;j<(width&7);j++) {
        if(byte&0x80) {
            *p=fg;
            p[1]=fg>>8;
            p[2]=fg>>16;
        } else if(!transparent) {
            *p=bg;
            p[1]=bg>>8;
            p[2]=bg>>16;
        }
        
        p+=3;
        byte<<=1;
    }    
}

int drawchar(font_element *font, int chr, int x, int y, int fg, int bg, int transparent)
{
    int i;

    y-=font[chr].metrics.horiBearingY>>6;
    if(y<0)return font[chr].metrics.horiAdvance;
    x+=font[chr].metrics.horiBearingX>>6;
    for(i=0;i<font[chr].bitmap.rows;i++) {
        switch(screen_bpp) {
            case 0:
                drawscansegment0linear(font[chr].bitmap.buffer+i*font[chr].bitmap.pitch, x, y+i, 
                               font[chr].bitmap.width, fg, bg, transparent);
            case 1:
                drawscansegment1linear(font[chr].bitmap.buffer+i*font[chr].bitmap.pitch, x, y+i, 
                               font[chr].bitmap.width, fg, bg, transparent);
            break;
            case 2:
                drawscansegment2linear(font[chr].bitmap.buffer+i*font[chr].bitmap.pitch, x, y+i, 
                               font[chr].bitmap.width, fg, bg, transparent);
            break;
            case 3:
                drawscansegment3linear(font[chr].bitmap.buffer+i*font[chr].bitmap.pitch, x, y+i, 
                               font[chr].bitmap.width, fg, bg, transparent);
            break;
            case 4:
                drawscansegment4linear(font[chr].bitmap.buffer+i*font[chr].bitmap.pitch, x, y+i, 
                               font[chr].bitmap.width, fg, bg, transparent);
            break;
        }
    }
    return (font[chr].metrics.horiAdvance);
}

#endif /* use drawscansegment */

int ft_writen(int x, int y, int n, unsigned char *s)
{
    int i=0;
    
    x<<=6;
    
    while((i<n) && s[i] && ((x>>6)+ft_font[s[i]].bitmap.width)*screen_bpp<screen_pitch) {
        x+=drawchar(ft_font,s[i++],x>>6,y,ft_fg,ft_bg,ft_transparent);
    }
    return x>>6;
}


