/* a simple front end for freetype */
/* use ft_writen the same as gl_writen 
     except that the variables ft_fg, ft_bg, ft_transparent and
     ft_font replace gl_setfont, gl_setfontcolors and gl_writemode
     loadfont is used to create a font */

#include "ft.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

static FT_Library ftlib=NULL;

/* all these variables need to be set by the program to the correct / wanted values */

int screen_pitch, screen_bpp;
int ft_fg, ft_bg, ft_transparent;
font_element *ft_font;


int checkfontencoding(char *fname, int *face_flags, int *style_flags, char *famname)
{
        int error;
	int i;
        FT_Face face;

        if(!ftlib) {
	    error = FT_Init_FreeType( &ftlib );
	    if (error) return error;
        }

        error = FT_New_Face( ftlib,
                               fname,
                               0,
                               &face );
        
        if(error==FT_Err_Unknown_File_Format) {
            return 0;
        }
        
        if (error)return 0;

        i=0;

        if(face_flags!=NULL)*face_flags=face->face_flags;
        if(style_flags!=NULL)*style_flags=face->style_flags;
        if(famname!=NULL)strncpy(famname,face->family_name,128);
 
        if(FT_Get_Char_Index(face,71)) {
            i|=1;
        }
        if(FT_Get_Char_Index(face,106)) {
            i|=2;
        }
        if(FT_Get_Char_Index(face,54)) {
            i|=4;
        }
        if(FT_Get_Char_Index(face,0x5dc)) {
            i|=8;
        }
        
        FT_Done_Face(face);

        return i;
}

int loadfont(FT_font *font, char *fname, int width, int height, int xres, int yres)
{
        FT_Bitmap bm;
        FT_GlyphSlot glyph;
        int error;
	int i;

        for(i=0;i<256;i++)font->chars[i].flags=0;

        if(!ftlib) {
	    error = FT_Init_FreeType( &ftlib );
	    if (error) return error;
        }

        error = FT_New_Face( ftlib,
                               fname,
                               0,
                               &font->face );
        
        if(error==FT_Err_Unknown_File_Format) {
            fprintf(stderr,"FreeType: %s is of unknown file format.\n",fname);
            return error;
        }

        if (error)return error;

	error=FT_Set_Char_Size(font->face,width,height,xres,yres);
        
        if (error)return error;

        if(width==0)width=height;
        font->height=height;
        font->width=width;
        font->x_resolution=xres;
        font->y_resolution=yres;

        font->ul_thickness=(font->face->underline_thickness*height*yres/72)/font->face->units_per_EM;
        font->ul_pos=(font->face->underline_position*height*yres/72)/font->face->units_per_EM;
        font->ul_pos+=font->ul_thickness>>1;
        font->ul_pos>>=6;
        font->ul_thickness>>=6;
        if(font->ul_thickness==0)font->ul_thickness=1;

        for(i=32;i<256;i++) {
            int glnum;
            int chr;
            
            chr=0;
            if((i>=32)&&(i<128))chr=i;
            if((i>=0xe0)&&(i<0xfb))chr=i+0x4f0; /* iso8859-8 to unicode */
            if(chr) {
                glnum=FT_Get_Char_Index(font->face,chr);
                FT_Load_Glyph(font->face,glnum,FT_LOAD_NO_SCALE);
                glyph=font->face->glyph;
		font->chars[i].horiAdvance=glyph->metrics.horiAdvance*width/font->face->units_per_EM;
                FT_Load_Glyph(font->face,glnum,FT_LOAD_DEFAULT);
                glyph=font->face->glyph;
                bm.rows = glyph->metrics.height >> 6;
                bm.width = glyph->metrics.width >> 6;
                bm.pitch = (bm.width+7) >> 3;
                bm.pixel_mode = ft_pixel_mode_mono;
                bm.buffer=(void *)calloc(1,bm.rows*bm.pitch);
    		FT_Translate_Outline(&glyph->outline, -(glyph->metrics.horiBearingX&0xffffffc0),
                    		     (glyph->metrics.height-glyph->metrics.horiBearingY)&0xffffffc0);
    		FT_Get_Outline_Bitmap(ftlib,&glyph->outline,&bm);
                font->chars[i].flags=1;
                font->chars[i].bitmap=bm;
                font->chars[i].metrics=glyph->metrics;
            }
        }
        
        return 0;
}

int changefontsize(FT_font *font, int width, int height, int xres, int yres)
{
        FT_Bitmap bm;
        FT_GlyphSlot glyph;
        int error;
	int i;

        if (!font->face)return -1;

        if(height==0)height=font->height;
        if(width==0)width=font->width;
        if(xres==0)font->x_resolution=xres;
        if(yres==0)font->y_resolution=yres;

        font->height=height;
        font->width=width;
        font->x_resolution=xres;
        font->y_resolution=yres;

	error=FT_Set_Char_Size(font->face,width,height,xres,yres);

        if (error)return error;
        
        font->ul_thickness=font->face->underline_thickness*height*yres/72/font->face->units_per_EM;
        font->ul_pos=font->face->underline_position*height*yres/72/font->face->units_per_EM;
        font->ul_pos+=font->ul_thickness>>1;
        font->ul_pos>>=6;
        font->ul_thickness>>=6;
        if(font->ul_thickness==0)font->ul_thickness=1;

        for(i=32;i<256;i++) if(font->chars[i].flags) {
            int glnum;
            int chr;
            
            free(font->chars[i].bitmap.buffer);
            chr=0;
            if((i>=32)&&(i<128))chr=i;
            if((i>=0xe0)&&(i<0xfb))chr=i+0x4f0; /* iso8859-8 to unicode */
            if(chr) {
                glnum=FT_Get_Char_Index(font->face,chr);
                FT_Load_Glyph(font->face,glnum,FT_LOAD_DEFAULT);
                glyph=font->face->glyph;
                bm.rows = glyph->metrics.height >> 6;
                bm.width = glyph->metrics.width >> 6;
                bm.pitch = (bm.width+7) >> 3;
                bm.pixel_mode = ft_pixel_mode_mono;
                bm.buffer=(void *)calloc(1,bm.rows*bm.pitch);

    		FT_Translate_Outline(&glyph->outline, -glyph->metrics.horiBearingX,
                    		     glyph->metrics.height-glyph->metrics.horiBearingY);
    		FT_Get_Outline_Bitmap(ftlib,&glyph->outline,&bm);
                font->chars[i].flags=1;
                font->chars[i].bitmap=bm;
                font->chars[i].metrics=glyph->metrics;
            }
        }
        
        return 0;
}

int releasefont(FT_font *font)
{
    int i;
    for(i=0;i<256;i++)if(font->chars[i].flags) {
        free(font->chars[i].bitmap.buffer);
        font->chars[i].flags=0;
    }
    FT_Done_Face(font->face);
    return 0;
}
