#include <string.h>

#include "bd.h"

static int insert_fontchange(par_t *par, int pos, int font)
{
    int j,i;

    if(pos>=strlen(par->text))return -1;
    j=fontof(par,pos);
    if(font==par->fontchange[j])return 0;
    if (pos==par->fontchangepos[j]) {
        par->fontchangepos[j]=pos;
        par->fontchange[j]=font;    
        return 0;
    }
    j++;
    if(j==par->numfontchanges) {
        par->fontchangepos[j]=pos;
        par->fontchange[j]=font;
        par->numfontchanges++;
    } else {
        for(i=par->numfontchanges;i>j;i--) {
            par->fontchangepos[i]=par->fontchangepos[i-1];
            par->fontchange[i]=par->fontchange[i-1];
        }
        par->fontchangepos[j]=pos;
        par->fontchange[j]=font;
        par->numfontchanges++;
    }

    return 0;
}

static int par_set_font_range(par_t *par, int st, int end, int font) {
    int i,j,k;
    
    j=fontof(par, end);
    if(par->fontchangepos[j]<=st) {
        k=par->fontchange[j];
        insert_fontchange(par,st,font);
        insert_fontchange(par,end,k);
    } else if(end==strlen(par->text)) {
        if(st==0)j=0; else j=fontof(par, st-1)+1;
        par->numfontchanges=j+1;
        par->fontchange[j]=font;
        par->fontchangepos[j]=st;
    } else {
        par->fontchangepos[j]=end;
        k=fontof(par,st);
        
        if(par->fontchangepos[k]==st) {
            par->fontchange[k]=font;
            for(i=j;i<par->numfontchanges;i++) {
                par->fontchange[i-j+k+1]=par->fontchange[i];
                par->fontchangepos[i-j+k+1]=par->fontchangepos[i];
            }
            par->numfontchanges-=(j-k-1);
        } else {
            if(j-k==1) { /* mess */
                insert_fontchange(par,st,font);
            } else {
                par->fontchange[k+1]=font;
                par->fontchangepos[k+1]=st;
                for(i=j;i<par->numfontchanges;i++) {
                    par->fontchange[i-j+k+2]=par->fontchange[i];
                    par->fontchangepos[i-j+k+2]=par->fontchangepos[i];
                }
                par->numfontchanges-=(j-k-2);
            }
        }
    }
    return 0;
}

/****************************************************************/

int split_par(par_t *par, int pos)
{
    par_t *tmp;
    int i, j;
    
    if(volatile_selection && selection()) {
        del_range(sel_st,sel_end);
        par=sel_st.par;
        pos=sel_st.pos;
        curpos=sel_st;
        sel_st.par=NULL;
    }

    tmp=new_par(par);

    if(!volatile_selection && selected(par,pos) && sel_end.par==par) {
        sel_end.par=tmp;
        sel_end.pos-=pos;
    }
    i=0;

    while((i<par->numfontchanges-1)&&(par->fontchangepos[i+1]<=pos))i++;

    for(j=0;j<par->numfontchanges-i;j++) {
        tmp->fontchange[j]=par->fontchange[j+i];
        tmp->fontchangepos[j]=(par->fontchangepos[j+i]-pos);
    }

    tmp->fontchangepos[0]=0;
    par->numfontchanges=i+1;
    tmp->numfontchanges=j;    
    strcpy(tmp->text,par->text+pos);
    par->text[pos]=0;

    insert_par(tmp,par->next);

    par->cacheflags=0;
    tmp->cacheflags=0;

    reformat(3, DPI, par);
    
    return 0;
}

int join_par(par_t *par) {
    int i, p;
    par_t *tmp;
    
    if(par->next==NULL)return 0;
    tmp=par->next;
    p=strlen(par->text);
    if(par->fontchangepos[par->numfontchanges-1]==p)par->numfontchanges--;
    for(i=0;i<tmp->numfontchanges;i++) {
        par->fontchange[par->numfontchanges+i]=tmp->fontchange[i];
        par->fontchangepos[par->numfontchanges+i]=tmp->fontchangepos[i]+p;
    }
    par->numfontchanges+=i;
    strcat(par->text,tmp->text);

    del_par(tmp);

    return 0;
}

int insert_char(par_t *par, int ch, int pos) {
    int i, ret;
    
    ret=0;
    if(volatile_selection&&selection()) {
        del_range(sel_st,sel_end);
        par=sel_st.par;
        pos=sel_st.pos;
        sel_st.par=NULL;
    } else {
        pos_t st;
        
        st.par=par;
        st.pos=pos;
        if(selection() && pos_prior(st,sel_end) && (sel_end.par==par))
            sel_end=pos_next(sel_end);
        if(selection() && pos_prior(st,sel_st) && (sel_st.par==par))
            sel_st=pos_next(sel_st);
    }
    for(i=strlen(par->text)+1;i>=pos;i--)par->text[i]=par->text[i-1];
    par->text[pos]=ch;
    i=0;
    while((i<par->numfontchanges) && (par->fontchangepos[i]<pos)) i++;
    if(i==0)i++;
    while(i<par->numfontchanges) par->fontchangepos[i++]++;
    par_set_font_range(par,pos,pos+1,curfont);
    curpos.par=par;
    curpos.pos=pos;
    curpos=pos_next(curpos);

    par->cacheflags=0;

    return ret;
}

int del_char(par_t *par, int pos) {
    pos_t st,end;
    if(volatile_selection&&selection()) {
        del_range(sel_st,sel_end);
        par=sel_st.par;
        pos=sel_st.pos;
        curpos=sel_st;
        sel_st.par=NULL;
    } else {
        st.par=par;
        st.pos=pos;
        end=pos_next(st);
        del_range(st,end);
        if(selection()&& pos_prior(st,sel_end)&&(sel_end.par==par))
            sel_end=pos_prev(sel_end);
        if(selection()&&pos_prior(st,sel_st)&&(sel_st.par==par))
            sel_st=pos_prev(sel_st);
    }
    return 0;
}

int del_chars(par_t *par, int first, int last) {
    int i, j, k;
    int l;
    int n;
    
    l=strlen(par->text);
    if(last>l)last=l;
    if(last<=first)return -1;
    n=last-first;
    
    for(i=first;i<=l-n;i++)par->text[i]=par->text[i+n];
    
    if(first==0)i=0; else i=fontof(par,first-1);
    j=fontof(par,last);
    if(i==j) {
        for(j=i+1;j<par->numfontchanges;j++)par->fontchangepos[j]-=n;
    } else {
        for(k=j;k<par->numfontchanges;k++) {
            par->fontchangepos[k+i+1-j]=par->fontchangepos[k];
            par->fontchange[k+i+1-j]=par->fontchange[k];
        }
        par->numfontchanges-=j-i-1;
        if(par->fontchangepos[i+1]>first)par->fontchangepos[i+1]=first;
        for(k=i+2;k<par->numfontchanges;k++) {
            par->fontchangepos[k]-=n;
        }
    }  
    
    par->cacheflags=0;
      
    return 0;
}

int set_par_style(par_t *par, int andmask, int ormask, int xormask) {
    par_t *fp, *lp;
    if(selection()) {
        fp=sel_st.par;
        lp=sel_end.par;
    } else {
        fp=par;
        lp=par;
    }
    
    while(fp!=lp){
        fp->style &= andmask;
        fp->style |= ormask;
        fp->style ^= xormask;
        fp=fp->next;
    }

    fp->style &= andmask;
    fp->style |= ormask;
    fp->style ^= xormask;

    fp->cacheflags=0;

    return 0;
}       

int set_font_range(pos_t st, pos_t end, int font) {
    int f=st.pos;
    int l;
    par_t *par=st.par;

    while(par!=end.par->next) {
        if(par==end.par)l=end.pos; else l=strlen(par->text);
        par_set_font_range(par,f,l,font);
        f=0;
        par=par->next;
    }
    
    return 0;
}

int del_range(pos_t st, pos_t end) {
    par_t *par=st.par;

    if(par==end.par) {
        del_chars(par,st.pos,end.pos);
    } else {
        par=par->next;
        while(par!=end.par) {
            del_par(par);
            par=par->next;
        }
        del_chars(st.par,st.pos,strlen(st.par->text));
        del_chars(end.par,0,end.pos);
        join_par(st.par);
    }
    reformat(2,DPI,st.par);
    return 0;
}


