#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include "bd.h"

static char basedir[128];
char fontpath[2040];
FT_font *fonts[256];
FT_font *ui_font;
FT_font *ui_sfont;
font_file_t *fontfiles[MAXFONTFILES];
int fontfilesnum;
int fontsnum;

int select_font(const struct dirent *dirent) {
    char tmp[256],fam[128]; 
    int ff,sf;
    int i;
    
    if(fontfilesnum==MAXFONTFILES)return 0;
    strcpy(tmp,basedir);
    strcat(tmp,dirent->d_name);    
    if(checkfontencoding(tmp,&ff,&sf,fam)==15) {
        i=0;
        while((i<fontfilesnum) && strcmp(fontfiles[i]->family,fam))i++;
        if(i==fontfilesnum) {
            fontfiles[i]=malloc(sizeof(font_file_t));
            strncpy(fontfiles[i]->family,fam,47);
            fontfiles[i]->style_flags=0;
            fontfiles[i]->face_flags=0;
            fontfiles[i]->flags=0;
            fontfilesnum++;
        }
        if((sf>=0) && (sf<4)) {
            strncpy(fontfiles[i]->fname[sf],tmp,175);
            fontfiles[i]->style_flags|=(1<<sf);
            fontfiles[i]->face_flags=ff; /* last one sets */
        }
    }
    return 0;
}

int compare_fonts(const void *p1, const void *p2) {
    font_file_t *f1, *f2;
    
    f1= *(font_file_t **)p1;
    f2= *(font_file_t **)p2;
    return strcmp(f1->family,f2->family);
}

int init_fonts()
{
    int i,j,l;

    fontfilesnum=0;
    l=strlen(fontpath);
    j=0;
    i=0;
    while(i<l) {
        while((i<l) && (fontpath[i]!=':'))i++;
        strncpy(basedir, fontpath+j, i-j);
        if(basedir[i-j-1]=='/') {
            basedir[i-j]=0;
        } else {
            basedir[i-j]='/';
            basedir[i-j+1]=0;
        }
        j=++i;
    
        scandir(basedir,NULL,select_font,NULL);

    }

    qsort(fontfiles, fontfilesnum, sizeof(font_file_t *),compare_fonts);
    
    return fontfilesnum;

}

int open_font(char *fam, int style, int size, int DPI) {
    int i,j;
    char fname[192];
    
    j=0;
    while(j<fontsnum) {
        if((fonts[j]->height==size) &&
           (fonts[j]->face->style_flags==style) &&
           !strcmp(fam,fonts[j]->face->family_name)) return j;
        j++;
    }

    for(i=0;i<fontfilesnum;i++) {
        if(!strcmp(fontfiles[i]->family,fam)) {
            if ((fontfiles[i]->style_flags&(1<<style))==0) return -1;
            strcpy(fname,fontfiles[i]->fname[style]);
            fonts[j]=malloc(sizeof(FT_font));
            loadfont(fonts[j],fname, 0, size, DPI, DPI);
            if(fonts[j]->face->height<fonts[j]->face->bbox.yMax-fonts[j]->face->bbox.yMin)
                fonts[j]->face->height=fonts[j]->face->bbox.yMax-fonts[j]->face->bbox.yMin;
            
	    fonts[j]->pix_height=fonts[j]->face->height*fonts[j]->height/72*DPI/fonts[j]->face->units_per_EM;
	    fonts[j]->ascender=fonts[j]->face->bbox.yMax*fonts[j]->height/72*DPI/fonts[j]->face->units_per_EM;
	    fonts[j]->descender=fonts[j]->face->bbox.yMin*fonts[j]->height/72*DPI/fonts[j]->face->units_per_EM;

            fontsnum++;
            return j;
        }
    }
    
    return -1;
}

int change_fontres(FT_font *f, int DPI) {
    
    changefontsize(f, 0, 0, DPI, DPI);
    if(f->face->height<f->face->bbox.yMax-f->face->bbox.yMin)
        f->face->height=f->face->bbox.yMax-f->face->bbox.yMin;
            
    f->pix_height=f->face->height*f->height/72*DPI/f->face->units_per_EM;
    f->ascender=f->face->bbox.yMax*f->height/72*DPI/f->face->units_per_EM;
    f->descender=f->face->bbox.yMin*f->height/72*DPI/f->face->units_per_EM;

    return 0;
}

int open_ui_font(char *fam, int style, int size, int DPI) {
    int i;
    char fname[192];
    int sdpi=DPI/2;
    
    if(sdpi<65)sdpi=65;
    
    for(i=0;i<fontfilesnum;i++) {
        if(!strcmp(fontfiles[i]->family,fam)) {
            if ((fontfiles[i]->style_flags&(1<<style))==0) return -1;
            strcpy(fname,fontfiles[i]->fname[style]);
            ui_font=malloc(sizeof(FT_font));
            loadfont(ui_font,fname, 0, size, DPI, DPI);
            if(ui_font->face->height<ui_font->face->bbox.yMax-ui_font->face->bbox.yMin)
                ui_font->face->height=ui_font->face->bbox.yMax-ui_font->face->bbox.yMin;
	    ui_font->pix_height=ui_font->face->height*ui_font->height/72*DPI/ui_font->face->units_per_EM;
            ui_sfont=malloc(sizeof(FT_font));
            loadfont(ui_sfont,fname, 0, size, sdpi, sdpi);
            if(ui_sfont->face->height<ui_sfont->face->bbox.yMax-ui_sfont->face->bbox.yMin)
                ui_sfont->face->height=ui_sfont->face->bbox.yMax-ui_sfont->face->bbox.yMin;
	    ui_sfont->pix_height=ui_sfont->face->height*ui_sfont->height/72*sdpi/ui_sfont->face->units_per_EM;
            return 0;
        }
    }

    return -1;
}

