#include <fribidi/fribidi.h>

#include "bd.h"

int pageof(int yp) {
    return yp/page_height;
}

int in_printable(int y, int h) {
    if((pageof(y)==pageof(y+h))&&(y-pageof(y)*page_height>page_top_margin)&&
       (y+h-pageof(y)*page_height<page_height-page_bottom_margin)) return 1; else return 0;
}

int next_printable(y) {
    if(y<page_top_margin)return page_top_margin; else 
    return (pageof(y-page_top_margin)+1)*page_height+page_top_margin;
}

int par_calc_font(par_t *par, int dpi) {
    int i;

    if(par->cacheflags&2)return -4;
    par->cacheflags|=2;
    par->font=fonts[par->fontchange[0]&0xfff];
    for(i=1;i<par->numfontchanges;i++)if(par->font->pix_height<fonts[par->fontchange[i]&0xfff]->pix_height)
        par->font=fonts[par->fontchange[i]&0xfff];
    par->line_point_height=(par->font->pix_height*72/dpi)>>6;
    par->line_pix_height=par->font->pix_height>>6;
    return 0;
}    

int par_calc_lines_ypos(par_t *par, int dpi) {
    int i, lh;

    if(par->cacheflags&4)return -4;
    par->cacheflags|=4;

    par->lines[0]->height=par->line_point_height;
    par->lines[0]->yoffs=par->firstlineskip;
    if(!in_printable(par->par_point_ypos+par->lines[0]->yoffs,par->lines[0]->height)) {
        par->lines[0]->yoffs=next_printable(par->par_point_ypos+par->lines[0]->yoffs)-par->par_point_ypos;
    }
    
    for(i=1;i<par->numlines;i++) {        
        if(par->lineskip>par->line_point_height)lh=par->lineskip; else
            lh=par->line_point_height;
        par->lines[i]->height=par->line_point_height;
        par->lines[i]->yskip=0;
        
        par->lines[i]->yoffs=par->lines[i-1]->yoffs+lh;
        if(!in_printable(par->par_point_ypos+par->lines[i]->yoffs,par->lines[i]->height)) {
           par->lines[i]->yoffs=next_printable(par->par_point_ypos+par->lines[i]->yoffs)-par->par_point_ypos;
        }
    }

    if(par->lineskip>par->line_point_height)lh=par->lineskip; else
        lh=par->line_point_height;

    par->par_point_height=par->lines[par->numlines-1]->yoffs+lh;
    return 0;
}

int par_calc_cursor(par_t *par, int dpi, int pos, int *bdx, int *bdline, int *bdcd, int *bdpos) {
    int line;

    line=0;
    while((line<par->numlines-1)&&(pos>=par->lines[line+1]->st))line++;
    *bdline=line;
    *bdcd=1;
    *bdx=par->xpos[pos]>>6;
    return 0;
}

int par_calc_xpos(par_t *par, int dpi, int line, int dir) {
    int j, x, mx, n, l;
    FT_font *fnt=fonts[0];

    if((par->lines[line]->len>1)&&((par->style&0x0c)==0x0c)&&(line<par->numlines-1)) {
        mx=par->par_point_width*dpi*8/9-(par->lines[line]->width<<6)-(par->lines[line]->indent<<6);
        n=par->lines[line]->len-1;
    } else {
        mx=0;
        n=1;
    }

    x=par->lines[line]->indent*64;
    l=par->lines[line]->end-par->lines[line]->st+1;
    if(par->lines[line]->len==0)par->lines[line]->width=0;
    for(j=0;j<l;j++) {
    	int m,k,p;

        m=0;
        if(dir==0) {
            p=j+par->lines[line]->st;
            k=par->v2l[p]+par->lines[line]->st;
        } else {
            if(j<par->lines[line]->len) { 
                p=par->lines[line]->visend-j; 
                k=par->v2l[p]+par->lines[line]->st;
            } else { 
                p=j+par->lines[line]->st;
                k=p;
            }
        }
        while((m<par->numfontchanges-1)&&(k>=par->fontchangepos[m+1]))m++;
        fnt=fonts[par->fontchange[m]&0xfff];
        par->xpos[k]=x;
        par->cfont[k]=par->fontchange[m];
        if(par->text[k]>=32) {
            x+=fnt->chars[par->text[k]].horiAdvance*dpi/72;
        } else {
            switch(par->text[k]) {
                case 9:
                    m=0;
                    while((m<par->numtabs)&&((par->tabs[m]<<6)*dpi<=x*72))m++;
                    if(m==par->numtabs) {
                        /* this means we are at end of line */
                    } else {
                        x=par->tabs[m]*dpi*8/9;
                    }
                    break;
            }
        }        
        if(j==par->lines[line]->len-1)par->lines[line]->width=x>>6;
        if(x>par->par_point_width*dpi*8/9)x=par->par_point_width*dpi*8/9;
    }
    if(line==par->numlines-1) {
        par->xpos[strlen(par->text)]=x;
    } else if((par->lines[line]->len>1)&&((par->style&0x0c)==0x0c)) {
        mx=par->par_point_width*dpi*8/9-(par->lines[line]->width<<6);
        n=par->lines[line]->len-1;
        for(j=0;j<par->lines[line]->len;j++) {
    	    int m,k,p;
            m=0;
            if(dir==0) {
                p=j+par->lines[line]->st;
            } else {
                p=par->lines[line]->visend-j; 
            }
            k=par->v2l[p]+par->lines[line]->st;
            par->xpos[k]+=mx*j/n;
        }
        for(j=par->lines[line]->visend+1;j<=par->lines[line]->end;j++) {
            par->xpos[j]=par->par_point_width*dpi*8/9;
        }
    }

    return 0;
}

int break_paragraph(par_t *par, int len, int dpi)
{
    int last, line, i, x, brk, fl, j, k;
    FriBidiChar unistr[1024], unistr2[1024];
    FriBidiCharType base, parbase;
    unsigned char tmpstr[1024];
    int width;
    FT_font *fnt;
    int fc;

    if(par->cacheflags&1)return -4;
    par->cacheflags|=1;
    
    par_calc_font(par,dpi);

    if(!len) {
        par->numlines=1;
        if(par->lines[0]==NULL) {
            par->lines[0]=malloc(sizeof(line_t));
        }
        par->lines[0]->st=0;
        par->lines[0]->end=0;
        par->lines[0]->visend=0;
        par->lines[0]->len=0;
        par->lines[0]->flags=0;
        par->lines[0]->indent=par->firstlineindent*dpi/72;
        par_calc_xpos(par,dpi,0,1);
        return 0;
    }

    switch(par->style&3) {
        case 0:
            parbase=FRIBIDI_TYPE_R;
            break;
        case 3:
            parbase=FRIBIDI_TYPE_L;
            break;
        default:
            parbase=FRIBIDI_TYPE_N;
            break;
    }

    width=par->par_point_width<<6; 
    last=0;
    line=0;
    if(par->lines[line]==NULL) {
        par->lines[line]=malloc(sizeof(line_t));
    }
    i=0;
    if(((par->style&0x1c)==0)||((par->style&0x1c)==0x0c))
        width-=par->firstlineindent<<6; 

    x=0;
    fl=0;
    
    fnt=fonts[par->fontchange[0]&0xfff];
    fc=1;
    
    for(;;) {
        fl=0;
        while((x<width) && par->text[i] && (i<len)) {
            if(par->text[i]>=' ') {
                x+=(fnt->chars[par->text[i]].horiAdvance);
            } else switch(par->text[i]) {
                case 31:
                    x=width;
                    fl |= 1;
                    break;
                case 9: /* tab */
                    j=0;
    		    k=x>>6;
                    if(line==0)k+=par->firstlineindent;
                    while((j<par->numtabs)&&(par->tabs[j]<k))j++;
                    if(j==par->numtabs) {
                        x=width;
                        fl |= 1;
                    } else {
                        x=par->tabs[j]<<6;
                        if(line==0)x-=par->firstlineindent<<6;
                    }
                    break;
            }
            if((x<width) && par->text[i] && (i<len)) {
                i++;
                if(i==par->fontchangepos[fc]) {
                    fnt=fonts[par->fontchange[fc]&0xfff];
                    fc++;
                }
            }
        }
    
        brk=i;
//        if(brk<=last+1)return -1;

        while((i>last)&&(par->text[i]>' ')) {
              /* should be par->text[i] is not breakable */
            i--;
            if(i==par->fontchangepos[fc-1]-1) {
                fc--;
                fnt=fonts[par->fontchange[fc-1]&0xfff];
            }
        }

        par->lines[line]->visend=i;
        while((par->lines[line]->visend>last)&&(par->text[par->lines[line]->visend]<=' '))
            par->lines[line]->visend--;

        if(!fl && ((!par->text[i]) || (i==len))) {

            par->lines[line]->end=par->text[i] ? i : i-1;
            par->lines[line]->len=par->lines[line]->visend-last+1;
            par->lines[line]->st=last;
            par->lines[line]->flags=1;
            if(line==0)par->lines[0]->indent=par->firstlineindent*dpi/72; else
                par->lines[line]->indent=0;
            
            base=parbase;
	    strncpy(tmpstr,&par->text[last],par->lines[line]->len);
            fribidi_iso8859_8_to_unicode(tmpstr, unistr);
            fribidi_log2vis(unistr,par->lines[line]->len,
                		&base,unistr2,par->v2l+par->lines[line]->st,NULL,NULL);
            fribidi_unicode_to_iso8859_8(unistr2, par->lines[line]->len, tmpstr);
	    strncpy(&par->vistext[last], tmpstr, par->lines[line]->len);

            par_calc_xpos(par,dpi,line,1);
            par->numlines=line+1;
            return 0;
        }
            
        if(i==last) {
            for(i=last;i<brk-1;) {
                if((++i)==par->fontchangepos[fc]) {
                    fnt=fonts[par->fontchange[fc]&0xfff];
                    fc++;
                }    
            }
        }

        par->lines[line]->st=last;
        par->lines[line]->end=i;
        par->lines[line]->flags=1;
        par->lines[line]->len=par->lines[line]->visend-last+1;
        if(line==0)par->lines[0]->indent=par->firstlineindent*dpi/72; else
            par->lines[line]->indent=0;

        base=parbase;
	strncpy(tmpstr,&par->text[last],par->lines[line]->len);
        tmpstr[par->lines[line]->len]=0;
        fribidi_iso8859_8_to_unicode(tmpstr, unistr);
        fribidi_log2vis(unistr,par->lines[line]->len,
            		&base,unistr2,par->v2l+par->lines[line]->st,NULL,NULL);
        fribidi_unicode_to_iso8859_8(unistr2, par->lines[line]->len, tmpstr);
	strncpy(&par->vistext[last], tmpstr, par->lines[line]->len);

        par_calc_xpos(par,dpi,line,1);

        fl=0;
	x=0;

        if((++i)==par->fontchangepos[fc]) {
            fnt=fonts[par->fontchange[fc]&0xfff];
            fc++;
        }
        while(par->text[i]==' ' && (i<len))
            if((++i)==par->fontchangepos[fc]) {
                fnt=fonts[par->fontchange[fc]&0xfff];
                fc++;
            }
        
        last=i;
        if(!line&&(((par->style&0x1c)==0)||((par->style&0x1c)==0x0c)))
            width+=par->firstlineindent<<6; 
	line++;
        if(par->lines[line]==NULL) {
            par->lines[line]=malloc(sizeof(line_t));
        }
    }
}

int reformat(int flags, int dpi, par_t *par)
/*
*/
{
    par_t *tmp;
    int ypos;
    
    if(par==NULL)return 0;

    tmp=par;
    
    if(tmp==first_par) {
        ypos=0;
    } else {
        ypos=tmp->prev->par_point_ypos+tmp->prev->par_point_height;
    }

    while(tmp!=NULL) {
        break_paragraph(tmp,strlen(tmp->text),dpi);
        if(ypos!=tmp->par_point_ypos) {
            tmp->par_point_ypos=ypos;
            tmp->cacheflags&=~4;
        }
        par_calc_lines_ypos(tmp,dpi);
        ypos+=tmp->par_point_height;
        tmp=tmp->next;
    }
    return 0;
}
