#include <stdio.h>
#include <stdlib.h>

#include "bd.h"

int PDPI;
char printfile[2040];

int print_ps() {
    
    FILE *file;
    unsigned char *image;
    par_t *par;
    int i;
    int height;
    int pagenum;
    int save_pitch, save_bpp, save_fg, save_bg, save_ts, save_ls, save_height;
    unsigned char *save_base;
     
    file=fopen(printfile,"w");

    if(file==NULL) return 1;

    for(i=0;i<fontsnum;i++)change_fontres(fonts[i],PDPI);

    save_base=graphbase;
    save_pitch=screen_pitch;
    save_bpp=screen_bpp;
    save_fg=ft_fg;
    save_bg=ft_bg;
    save_ls=left_skip;
    save_ts=top_skip;
    save_height=display_pix_height;
    
    screen_pitch=WIDTH*PDPI/72;
    screen_bpp=1;
    ft_fg=0xff;
    ft_bg=0;
    left_skip=0;
    top_skip=0;

    display_pix_height=HEIGHT*PDPI/72+100;
    
    image=(unsigned char *)malloc(screen_pitch*display_pix_height);
    graphbase=image;
    memset(image,0,screen_pitch*display_pix_height);

    clear_flags();
    for(par=first_par;par!=NULL;par=par->next){ 
        par->cacheflags=0;
    }
    
    reformat(1,PDPI,first_par);

    par=first_par;
    pagenum=1;
    
    fprintf(file,"%%!PS-Adobe-2.0 EPSF-2.0\n");
    fprintf(file,"%%%%Creator: bdft\n");
    fprintf(file,"%%%%Title: bd.ps\n");
    fprintf(file,"%%%%Pages: (atend)\n");
    fprintf(file,"%%%%BoundingBox: %i %i %i %i\n",page_left_margin,page_bottom_margin,
        			page_width-page_right_margin,page_height-page_top_margin);
    fprintf(file,"%%%%EndComments\n");
    fprintf(file,"/readstring {\n");
    fprintf(file,"  currentfile exch readhexstring pop\n");
    fprintf(file,"} bind def\n");
    fprintf(file,"/picstr %i string def\n", 1 /*(screen_pitch+7)>>3*/);
    fprintf(file,"%%%%EndProlog\n");

    while(last_par->par_point_ypos+last_par->par_point_height>
        		(pagenum-1)*page_height) {
        char *im;
        int j, k, l, val;

        while((par!=NULL)&&(par->par_point_ypos<pagenum*page_height)){
            display_par_simple(par,0,0,0,0,0x311,PDPI,(pagenum-1)*page_height+page_top_margin);
            par=par->next;
        }
        
        if(par!=NULL)par=par->prev; else par=last_par;
        
        height=72*lasty/PDPI;
        
        fprintf(file,"%%%%Page: %i %i\n",pagenum, pagenum);

        fprintf(file,"gsave\n");
        fprintf(file,"%i %i translate\n",page_left_margin,page_height-page_top_margin-height);
        fprintf(file,"%i %i scale\n",WIDTH,height);
        fprintf(file,"%i %i 1\n",screen_pitch,lasty);
        fprintf(file,"[ %i 0 0 %i 0 %i ]\n",screen_pitch,-lasty,lasty);
        fprintf(file,"{ picstr readstring }\n");
        fprintf(file,"image\n");
        im=image;
        l=0;
        for(k=0;k<lasty;k++) {
            val=0;
            for(j=0;j<screen_pitch;j++) {
                val<<=1;
                val+=*(im++)?0:1;
                if((j&7)==7) {
                    fprintf(file,"%02x",val);
                    l++;
                    if(l==30) {
                        fprintf(file,"\n");
                        l=0;
                    }
                    val=0;
                }
            }
            if(j&7) {
                val<<=(8-(j&7));
                fprintf(file,"%02x",val);
                l++;
                if(l==30) {
                    fprintf(file,"\n");
                    l=0;
                }
            }
        }
        fprintf(file,"\n");

        fprintf(file,"grestore\n");
        fprintf(file,"showpage\n");

        memset(image,0,screen_pitch*display_pix_height);
        pagenum++;

    }

    fprintf(file,"%%%%Trailer\n");
    fprintf(file,"end\n");
    fprintf(file,"%%%%Pages: %i\n",pagenum-1);

    fclose(file);

    for(i=0;i<fontsnum;i++) {
        change_fontres(fonts[i],DPI);
    }

    reformat(1,DPI,first_par);

    graphbase=save_base;
    screen_pitch=save_pitch;
    screen_bpp=save_bpp;
    ft_fg=save_fg;
    ft_bg=save_bg;
    left_skip=save_ls;
    top_skip=save_ts;
    display_pix_height=save_height;
    
    return 0;
}

int print_pcl() {
    
    FILE *file;
    unsigned char *image;
    par_t *par;
    int i;
    int height;
    int pagenum;
    int save_pitch, save_bpp, save_fg, save_bg, save_ts, save_ls, save_height;
    unsigned char *save_base;
     
    file=fopen(printfile,"w");

    if(file==NULL) return 1;

    for(i=0;i<fontsnum;i++)changefontsize(fonts[i],0,0,PDPI,PDPI);

    save_base=graphbase;
    save_pitch=screen_pitch;
    save_bpp=screen_bpp;
    save_fg=ft_fg;
    save_bg=ft_bg;
    save_ls=left_skip;
    save_ts=top_skip;
    save_height=display_pix_height;
    
    screen_pitch=WIDTH*PDPI/72;
    screen_bpp=1;
    ft_fg=0xff;
    ft_bg=0;
    left_skip=0;
    top_skip=0;

    display_pix_height=HEIGHT*PDPI/72+100;
    
    image=(unsigned char *)malloc(screen_pitch*display_pix_height);
    graphbase=image;
    memset(image,0,screen_pitch*display_pix_height);

    par=first_par;
    pagenum=1;
    
    fprintf(file,"\n");

    reformat(1,PDPI,first_par);

    while(last_par->par_point_ypos+last_par->par_point_height>
        		(pagenum-1)*height) {
        char *im;
        int j, k, l, val;

        while((par!=NULL)&&(par->par_point_ypos<pagenum*height)){
            display_par_simple(par,0,0,0,0,0x311,PDPI,(pagenum-1)*height+page_top_margin);
            par=par->next;
        }
        if(par!=NULL)par=par->prev; else par=last_par;
        
        height=72*lasty/PDPI;
        
        fprintf(file,"%%%%Page: %i %i\n",pagenum, pagenum);

        fprintf(file,"gsave\n");
        fprintf(file,"%i %i translate\n",page_left_margin,page_height-page_top_margin-height);
        fprintf(file,"%i %i scale\n",WIDTH,height);
        fprintf(file,"%i %i 1\n",screen_pitch,lasty);
        fprintf(file,"[ %i 0 0 %i 0 %i ]\n",screen_pitch,-lasty,lasty);
        fprintf(file,"{ picstr readstring }\n");
        fprintf(file,"image\n");
        im=image;
        l=0;
        for(k=0;k<lasty;k++) {
            val=0;
            for(j=0;j<screen_pitch;j++) {
                val<<=1;
                val+=*(im++)?0:1;
                if((j&7)==7) {
                    fprintf(file,"%02x",val);
                    l++;
                    if(l==30) {
                        fprintf(file,"\n");
                        l=0;
                    }
                    val=0;
                }
            }
            if(j&7) {
                val<<=(8-(j&7));
                fprintf(file,"%02x",val);
                l++;
                if(l==30) {
                    fprintf(file,"\n");
                    l=0;
                }
            }
        }
        fprintf(file,"\n");

        fprintf(file,"grestore\n");
        fprintf(file,"showpage\n");

        memset(image,0,screen_pitch*display_pix_height);
        pagenum++;

    }

    fprintf(file,"%%%%Trailer\n");
    fprintf(file,"end\n");
    fprintf(file,"%%%%Pages: %i\n",pagenum-1);

    fclose(file);

    for(i=0;i<fontsnum;i++) {
        changefontsize(fonts[i],0,0,DPI,DPI);
    }

    graphbase=save_base;
    screen_pitch=save_pitch;
    screen_bpp=save_bpp;
    ft_fg=save_fg;
    ft_bg=save_bg;
    left_skip=save_ls;
    top_skip=save_ts;
    display_pix_height=save_height;
    
    return 0;
}


